/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.tools.cache.StructureCache;
import mcjty.incontrol.tools.rules.CommonRuleKeys;
import mcjty.incontrol.tools.rules.IEventQuery;
import mcjty.incontrol.tools.rules.IModRuleCompatibilityLayer;
import mcjty.incontrol.tools.typed.AttributeMap;
import mcjty.incontrol.tools.varia.LookAtTools;
import mcjty.incontrol.tools.varia.Tools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public class CommonRuleEvaluator {
    protected final List<BiFunction<Object, IEventQuery, Boolean>> checks = new ArrayList<BiFunction<Object, IEventQuery, Boolean>>();
    private final Logger logger;
    private final IModRuleCompatibilityLayer compatibility;
    private static final Random rnd = new Random();

    public CommonRuleEvaluator(AttributeMap map, Logger logger, IModRuleCompatibilityLayer compatibility) {
        this.logger = logger;
        this.compatibility = compatibility;
        this.addChecks(map);
    }

    protected void addChecks(AttributeMap map) {
        map.consume(CommonRuleKeys.RANDOM, this::addRandomCheck);
        map.consumeAsList(CommonRuleKeys.DIMENSION, this::addDimensionCheck);
        map.consumeAsList(CommonRuleKeys.DIMENSION_MOD, this::addDimensionModCheck);
        map.consume(CommonRuleKeys.TIME, this::addTimeCheck);
        map.consume(CommonRuleKeys.MINTIME, this::addMinTimeCheck);
        map.consume(CommonRuleKeys.MAXTIME, this::addMaxTimeCheck);
        map.consume(CommonRuleKeys.HEIGHT, this::addHeightCheck);
        map.consume(CommonRuleKeys.MINHEIGHT, this::addMinHeightCheck);
        map.consume(CommonRuleKeys.MAXHEIGHT, this::addMaxHeightCheck);
        map.consume(CommonRuleKeys.WEATHER, this::addWeatherCheck);
        map.consumeAsList(CommonRuleKeys.CATEGORY, this::addCategoryCheck);
        map.consume(CommonRuleKeys.DIFFICULTY, this::addDifficultyCheck);
        map.consume(CommonRuleKeys.MINSPAWNDIST, this::addMinSpawnDistCheck);
        map.consume(CommonRuleKeys.MAXSPAWNDIST, this::addMaxSpawnDistCheck);
        map.consume(CommonRuleKeys.LIGHT, this::addLightCheck);
        map.consume(CommonRuleKeys.MINLIGHT, this::addMinLightCheck);
        map.consume(CommonRuleKeys.MAXLIGHT, this::addMaxLightCheck);
        map.consume(CommonRuleKeys.MINDIFFICULTY, this::addMinAdditionalDifficultyCheck);
        map.consume(CommonRuleKeys.MAXDIFFICULTY, this::addMaxAdditionalDifficultyCheck);
        map.consume(CommonRuleKeys.SEESKY, this::addSeeSkyCheck);
        map.consume(CommonRuleKeys.SLIME, this::addSlimeChunkCheck);
        map.consumeAsList(CommonRuleKeys.BLOCK, b -> this.addBlocksCheck(map, (List<String>)b));
        map.consumeAsList(CommonRuleKeys.BIOME, this::addBiomesCheck);
        map.consumeAsList(CommonRuleKeys.BIOMETYPE, this::addBiomeTypesCheck);
        map.consumeAsList(CommonRuleKeys.HELMET, this::addHelmetCheck);
        map.consumeAsList(CommonRuleKeys.CHESTPLATE, this::addChestplateCheck);
        map.consumeAsList(CommonRuleKeys.LEGGINGS, this::addLeggingsCheck);
        map.consumeAsList(CommonRuleKeys.BOOTS, this::addBootsCheck);
        map.consumeAsList(CommonRuleKeys.PLAYER_HELDITEM, this::addHeldItemCheck);
        map.consumeAsList(CommonRuleKeys.HELDITEM, this::addHeldItemCheck);
        map.consumeAsList(CommonRuleKeys.OFFHANDITEM, this::addOffHandItemCheck);
        map.consumeAsList(CommonRuleKeys.BOTHHANDSITEM, this::addBothHandsItemCheck);
        map.consume(CommonRuleKeys.STRUCTURE, this::addStructureCheck);
        map.consumeAsList(CommonRuleKeys.SCOREBOARDTAGS_ALL, this::addAllScoreboardTagsCheck);
        map.consumeAsList(CommonRuleKeys.SCOREBOARDTAGS_ANY, this::addAnyScoreboardTagsCheck);
        map.consume(CommonRuleKeys.STATE, this::addStateCheck);
        map.consume(CommonRuleKeys.PSTATE, this::addPStateCheck);
        map.consume(CommonRuleKeys.SUMMER, this::addSummerCheck);
        map.consume(CommonRuleKeys.WINTER, this::addWinterCheck);
        map.consume(CommonRuleKeys.SPRING, this::addSpringCheck);
        map.consume(CommonRuleKeys.AUTUMN, this::addAutumnCheck);
        map.consume(CommonRuleKeys.GAMESTAGE, this::addGameStageCheck);
        map.consume(CommonRuleKeys.INCITY, this::addInCityCheck);
        map.consume(CommonRuleKeys.INSTREET, this::addInStreetCheck);
        map.consume(CommonRuleKeys.INSPHERE, this::addInSphereCheck);
        map.consume(CommonRuleKeys.INBUILDING, this::addInBuildingCheck);
        map.consumeAsList(CommonRuleKeys.BUILDING, this::addBuildingCheck);
        map.consumeAsList(CommonRuleKeys.AMULET, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getAmuletSlots));
        map.consumeAsList(CommonRuleKeys.RING, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getRingSlots));
        map.consumeAsList(CommonRuleKeys.BELT, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getBeltSlots));
        map.consumeAsList(CommonRuleKeys.TRINKET, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getTrinketSlots));
        map.consumeAsList(CommonRuleKeys.HEAD, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getHeadSlots));
        map.consumeAsList(CommonRuleKeys.BODY, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getBodySlots));
        map.consumeAsList(CommonRuleKeys.CHARM, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getCharmSlots));
    }

    private void addRandomCheck(float r) {
        this.checks.add((event, query) -> rnd.nextFloat() < r);
    }

    private void addSeeSkyCheck(boolean seesky) {
        if (seesky) {
            this.checks.add((event, query) -> {
                LevelAccessor world = query.getWorld(event);
                BlockPos pos = query.getPos(event);
                LevelChunk chunk = world.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
                if (chunk == null || !chunk.m_6415_().m_62427_(ChunkStatus.f_62326_)) {
                    return false;
                }
                return world.m_46861_(pos);
            });
        } else {
            this.checks.add((event, query) -> {
                LevelAccessor world = query.getWorld(event);
                BlockPos pos = query.getPos(event);
                LevelChunk chunk = world.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
                if (chunk == null || !chunk.m_6415_().m_62427_(ChunkStatus.f_62326_)) {
                    return false;
                }
                return !world.m_46861_(pos);
            });
        }
    }

    private void addSlimeChunkCheck(boolean slime) {
        if (slime) {
            this.checks.add((event, query) -> this.isSlimeChunk(new ChunkPos(query.getPos(event)), query.getWorld(event)));
        } else {
            this.checks.add((event, query) -> !this.isSlimeChunk(new ChunkPos(query.getPos(event)), query.getWorld(event)));
        }
    }

    private boolean isSlimeChunk(ChunkPos cp, LevelAccessor world) {
        long seed = 0L;
        if (world instanceof WorldGenLevel) {
            WorldGenLevel level = (WorldGenLevel)world;
            seed = level.m_7328_();
        }
        return WorldgenRandom.m_64685_((int)cp.f_45578_, (int)cp.f_45579_, (long)seed, (long)987234911L).nextInt(10) == 0;
    }

    private void addDimensionCheck(List<ResourceKey<Level>> dimensions) {
        if (dimensions.size() == 1) {
            ResourceKey<Level> dim = dimensions.get(0);
            this.checks.add((event, query) -> Tools.getDimensionKey(query.getWorld(event)).equals((Object)dim));
        } else {
            HashSet<ResourceKey<Level>> dims = new HashSet<ResourceKey<Level>>(dimensions);
            this.checks.add((event, query) -> dims.contains(Tools.getDimensionKey(query.getWorld(event))));
        }
    }

    private void addDimensionModCheck(List<String> dimensions) {
        if (dimensions.size() == 1) {
            String dimmod = dimensions.get(0);
            this.checks.add((event, query) -> Tools.getDimensionKey(query.getWorld(event)).m_135782_().m_135827_().equals(dimmod));
        } else {
            HashSet<String> dims = new HashSet<String>(dimensions);
            this.checks.add((event, query) -> dims.contains(Tools.getDimensionKey(query.getWorld(event)).m_135782_().m_135827_()));
        }
    }

    private void addDifficultyCheck(String difficulty) {
        Difficulty diff = Difficulty.m_19031_((String)(difficulty = difficulty.toLowerCase()));
        if (diff != null) {
            Difficulty finalDiff = diff;
            this.checks.add((event, query) -> query.getWorld(event).m_46791_() == finalDiff);
        } else {
            ErrorHandler.error("Unknown difficulty '" + difficulty + "'! Use one of 'easy', 'normal', 'hard',  or 'peaceful'");
        }
    }

    private void addWeatherCheck(String weather) {
        boolean raining = weather.toLowerCase().startsWith("rain");
        boolean thunder = weather.toLowerCase().startsWith("thunder");
        if (raining) {
            this.checks.add((event, query) -> {
                LevelAccessor world = query.getWorld(event);
                if (world instanceof Level) {
                    return ((Level)world).m_46471_();
                }
                return false;
            });
        } else if (thunder) {
            this.checks.add((event, query) -> {
                LevelAccessor world = query.getWorld(event);
                if (world instanceof Level) {
                    return ((Level)world).m_46470_();
                }
                return false;
            });
        } else {
            ErrorHandler.error("Unknown weather '" + weather + "'! Use 'rain' or 'thunder'");
        }
    }

    private void addCategoryCheck(List<String> list) {
        Set categories = list.stream().map(s -> Biome.BiomeCategory.m_47643_((String)s.toLowerCase())).collect(Collectors.toSet());
        this.checks.add((event, query) -> {
            Holder biome = query.getWorld(event).m_204166_(query.getPos(event));
            return categories.contains(Biome.m_204183_((Holder)biome));
        });
    }

    private void addAllScoreboardTagsCheck(List<String> list) {
        HashSet<String> tags = new HashSet<String>(list);
        this.checks.add((event, query) -> {
            Entity entity = query.getEntity(event);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return living.m_19880_().containsAll(tags);
            }
            return false;
        });
    }

    private void addAnyScoreboardTagsCheck(List<String> list) {
        HashSet<String> tags = new HashSet<String>(list);
        this.checks.add((event, query) -> {
            Entity entity = query.getEntity(event);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return living.m_19880_().stream().anyMatch(tags::contains);
            }
            return false;
        });
    }

    private void addStructureCheck(String structure) {
        this.checks.add((event, query) -> StructureCache.CACHE.isInStructure(query.getWorld(event), structure, query.getPos(event)));
    }

    private void addBiomesCheck(List<String> biomes) {
        if (biomes.size() == 1) {
            String biomename = biomes.get(0);
            this.checks.add((event, query) -> {
                Holder biome = query.getWorld(event).m_204166_(query.getPos(event));
                return Tools.getBiomeId((Holder<Biome>)biome).equals(biomename);
            });
        } else {
            HashSet<String> biomenames = new HashSet<String>(biomes);
            this.checks.add((event, query) -> {
                Holder biome = query.getWorld(event).m_204166_(query.getPos(event));
                String biomeId = Tools.getBiomeId((Holder<Biome>)biome);
                return biomenames.contains(biomeId);
            });
        }
    }

    private void addBiomeTypesCheck(List<String> biomeTypes) {
        HashSet biomes = new HashSet();
        biomeTypes.stream().map(s -> BiomeManager.BiomeType.valueOf((String)s.toUpperCase())).forEach(type -> BiomeManager.getBiomes((BiomeManager.BiomeType)type).forEach(t -> biomes.add((Biome)ForgeRegistries.BIOMES.getValue(t.getKey().getRegistryName()))));
        this.checks.add((event, query) -> {
            Holder biome = query.getWorld(event).m_204166_(query.getPos(event));
            return biomes.contains(biome.m_203334_());
        });
    }

    public static <T extends Comparable<T>> BlockState set(BlockState state, Property<T> property, String value) {
        Optional optionalValue = property.m_6215_(value);
        return optionalValue.map(t -> (BlockState)state.m_61124_(property, t)).orElse(state);
    }

    @Nonnull
    private BiFunction<Object, IEventQuery, BlockPos> parseOffset(String json) {
        int offsetZ;
        int offsetY;
        int offsetX;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("offset")) {
            JsonObject offset = obj.getAsJsonObject("offset");
            offsetX = offset.has("x") ? offset.get("x").getAsInt() : 0;
            offsetY = offset.has("y") ? offset.get("y").getAsInt() : 0;
            offsetZ = offset.has("z") ? offset.get("z").getAsInt() : 0;
        } else {
            offsetX = obj.has("x") ? obj.get("x").getAsInt() : 0;
            offsetY = obj.has("y") ? obj.get("y").getAsInt() : 0;
            int n = offsetZ = obj.has("z") ? obj.get("z").getAsInt() : 0;
        }
        if (obj.has("look")) {
            return (event, query) -> {
                HitResult result = LookAtTools.getMovingObjectPositionFromPlayer(query.getWorld(event), query.getPlayer(event), false);
                if (result instanceof BlockHitResult) {
                    return ((BlockHitResult)result).m_82425_().m_142082_(offsetX, offsetY, offsetZ);
                }
                return query.getValidBlockPos(event).m_142082_(offsetX, offsetY, offsetZ);
            };
        }
        return (event, query) -> query.getValidBlockPos(event).m_142082_(offsetX, offsetY, offsetZ);
    }

    private static boolean testBlockStateSafe(LevelAccessor world, BlockPos pos, Block block) {
        LevelChunk chunk = world.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        if (chunk != null) {
            BlockState state = world.m_8055_(pos);
            return state.m_60734_() == block;
        }
        return false;
    }

    private static boolean testBlockStateSafe(LevelAccessor world, BlockPos pos, BlockState block) {
        LevelChunk chunk = world.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        if (chunk != null) {
            BlockState state = world.m_8055_(pos);
            return state == block;
        }
        return false;
    }

    @Nullable
    private BiPredicate<LevelAccessor, BlockPos> parseBlock(String json) {
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        if (element.isJsonPrimitive()) {
            String blockname = element.getAsString();
            if (blockname.startsWith("tag:")) {
                ResourceLocation tagname = new ResourceLocation(blockname.substring(4));
                TagKey key = TagKey.m_203882_((ResourceKey)Registry.f_122824_.m_123023_(), (ResourceLocation)tagname);
                return (world, pos) -> {
                    BlockState state = world.m_8055_(pos);
                    return state.m_204336_(key);
                };
            }
            if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockname))) {
                ErrorHandler.error("Block '" + blockname + "' is not valid!");
                return null;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
            return (world, pos) -> CommonRuleEvaluator.testBlockStateSafe(world, pos, block);
        }
        if (element.isJsonObject()) {
            BiPredicate<LevelAccessor, BlockPos> finalTest;
            Predicate<Integer> energy;
            BiPredicate<LevelAccessor, BlockPos> test;
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("tag")) {
                ResourceLocation tagname = new ResourceLocation(obj.get("tag").getAsString());
                TagKey key = TagKey.m_203882_((ResourceKey)Registry.f_122824_.m_123023_(), (ResourceLocation)tagname);
                test = (world, pos) -> {
                    BlockState state = world.m_8055_(pos);
                    return state.m_204336_(key);
                };
            } else if (obj.has("block")) {
                String blockname = obj.get("block").getAsString();
                if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockname))) {
                    ErrorHandler.error("Block '" + blockname + "' is not valid!");
                    return null;
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
                if (obj.has("properties")) {
                    BlockState blockState = block.m_49966_();
                    JsonArray propArray = obj.get("properties").getAsJsonArray();
                    for (JsonElement el : propArray) {
                        JsonObject propObj = el.getAsJsonObject();
                        String name = propObj.get("name").getAsString();
                        String value = propObj.get("value").getAsString();
                        for (Property key : blockState.m_61147_()) {
                            if (!name.equals(key.m_61708_())) continue;
                            blockState = CommonRuleEvaluator.set(blockState, key, value);
                        }
                    }
                    BlockState finalBlockState = blockState;
                    test = (world, pos) -> CommonRuleEvaluator.testBlockStateSafe(world, pos, finalBlockState);
                } else {
                    test = (world, pos) -> CommonRuleEvaluator.testBlockStateSafe(world, pos, block);
                }
            } else {
                test = (world, pos) -> true;
            }
            if (obj.has("mod")) {
                String mod = obj.get("mod").getAsString();
                BiPredicate<LevelAccessor, BlockPos> finalTest2 = test;
                test = (world, pos) -> {
                    LevelChunk chunk = world.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
                    if (chunk != null) {
                        return finalTest2.test((LevelAccessor)world, (BlockPos)pos) && mod.equals(world.m_8055_(pos).m_60734_().getRegistryName().m_135827_());
                    }
                    return false;
                };
            }
            if (obj.has("energy") && (energy = CommonRuleEvaluator.getExpression(obj.get("energy"))) != null) {
                Direction side = obj.has("side") ? Direction.m_122402_((String)obj.get("side").getAsString().toLowerCase()) : null;
                finalTest = test;
                test = (world, pos) -> finalTest.test((LevelAccessor)world, (BlockPos)pos) && energy.test(this.getEnergy((LevelAccessor)world, (BlockPos)pos, side));
            }
            if (obj.has("contains")) {
                Direction side = obj.has("side") ? Direction.m_122402_((String)obj.get("energyside").getAsString().toLowerCase()) : null;
                List<Predicate<ItemStack>> items = this.getItems(obj.get("contains"));
                finalTest = test;
                test = (world, pos) -> finalTest.test((LevelAccessor)world, (BlockPos)pos) && this.contains((LevelAccessor)world, (BlockPos)pos, side, items);
            }
            return test;
        }
        ErrorHandler.error("Block description '" + json + "' is not valid!");
        return null;
    }

    protected List<Predicate<ItemStack>> getItems(JsonElement itemObj) {
        ArrayList<Predicate<ItemStack>> items = new ArrayList<Predicate<ItemStack>>();
        if (itemObj.isJsonObject()) {
            Predicate<ItemStack> matcher = CommonRuleEvaluator.getMatcher(itemObj.getAsJsonObject(), this.logger);
            if (matcher != null) {
                items.add(matcher);
            }
        } else if (itemObj.isJsonArray()) {
            for (JsonElement element : itemObj.getAsJsonArray()) {
                JsonObject obj = element.getAsJsonObject();
                Predicate<ItemStack> matcher = CommonRuleEvaluator.getMatcher(obj, this.logger);
                if (matcher == null) continue;
                items.add(matcher);
            }
        } else {
            ErrorHandler.error("Item description is not valid!");
        }
        return items;
    }

    private void addBlocksCheck(AttributeMap map, List<String> blocks) {
        String bo = map.consumeAndFetch(CommonRuleKeys.BLOCKOFFSET);
        BiFunction<Object, IEventQuery, BlockPos> posFunction = bo != null ? this.parseOffset(bo) : (event, query) -> query.getValidBlockPos(event);
        if (blocks.size() == 1) {
            String json = blocks.get(0);
            BiPredicate<LevelAccessor, BlockPos> blockMatcher = this.parseBlock(json);
            if (blockMatcher != null) {
                this.checks.add((event, query) -> {
                    BlockPos pos = (BlockPos)posFunction.apply(event, (IEventQuery)query);
                    return pos != null && blockMatcher.test(query.getWorld(event), pos);
                });
            }
        } else {
            ArrayList<BiPredicate<LevelAccessor, BlockPos>> blockMatchers = new ArrayList<BiPredicate<LevelAccessor, BlockPos>>();
            for (String block : blocks) {
                BiPredicate<LevelAccessor, BlockPos> blockMatcher = this.parseBlock(block);
                if (blockMatcher == null) {
                    return;
                }
                blockMatchers.add(blockMatcher);
            }
            this.checks.add((event, query) -> {
                BlockPos pos = (BlockPos)posFunction.apply(event, (IEventQuery)query);
                if (pos != null) {
                    LevelAccessor world = query.getWorld(event);
                    for (BiPredicate matcher : blockMatchers) {
                        if (!matcher.test(world, pos)) continue;
                        return true;
                    }
                }
                return false;
            });
        }
    }

    private void addTimeCheck(String time) {
        Predicate<Integer> expression = Tools.parseExpression(time);
        if (expression != null) {
            this.checks.add((event, query) -> {
                LevelAccessor world = query.getWorld(event);
                if (world instanceof Level) {
                    long t = ((Level)world).m_46468_();
                    return expression.test((int)(t % 24000L));
                }
                return false;
            });
        }
    }

    private void addMinTimeCheck(int mintime) {
        this.checks.add((event, query) -> {
            LevelAccessor world = query.getWorld(event);
            if (world instanceof Level) {
                long time = ((Level)world).m_46468_();
                return time % 24000L >= (long)mintime;
            }
            return false;
        });
    }

    private void addMaxTimeCheck(int maxtime) {
        this.checks.add((event, query) -> {
            LevelAccessor world = query.getWorld(event);
            if (world instanceof Level) {
                long time = ((Level)world).m_46468_();
                return time % 24000L <= (long)maxtime;
            }
            return false;
        });
    }

    private void addMinSpawnDistCheck(float v) {
        float d = v * v;
        this.checks.add((event, query) -> {
            ServerLevel sw;
            BlockPos pos = query.getPos(event);
            double sqdist = pos.m_123331_((Vec3i)(sw = Tools.getServerWorld(query.getWorld(event))).m_8900_());
            return sqdist >= (double)d;
        });
    }

    private void addMaxSpawnDistCheck(float v) {
        float d = v * v;
        this.checks.add((event, query) -> {
            ServerLevel sw;
            BlockPos pos = query.getPos(event);
            double sqdist = pos.m_123331_((Vec3i)(sw = Tools.getServerWorld(query.getWorld(event))).m_8900_());
            return sqdist <= (double)d;
        });
    }

    private void addLightCheck(String expression) {
        Predicate<Integer> exp = Tools.parseExpression(expression);
        if (exp != null) {
            this.checks.add((event, query) -> {
                BlockPos pos = query.getPos(event);
                LevelAccessor world = query.getWorld(event);
                LevelChunk chunk = world.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
                if (chunk == null || !chunk.m_6415_().m_62427_(ChunkStatus.f_62326_)) {
                    return false;
                }
                return exp.test(world.m_45517_(LightLayer.BLOCK, pos));
            });
        }
    }

    private void addMinLightCheck(int minlight) {
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            LevelAccessor world = query.getWorld(event);
            LevelChunk chunk = world.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
            if (chunk == null || !chunk.m_6415_().m_62427_(ChunkStatus.f_62326_)) {
                return false;
            }
            return world.m_45517_(LightLayer.BLOCK, pos) >= minlight;
        });
    }

    private void addMaxLightCheck(int maxlight) {
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            LevelAccessor world = query.getWorld(event);
            LevelChunk chunk = world.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
            if (chunk == null || !chunk.m_6415_().m_62427_(ChunkStatus.f_62326_)) {
                return false;
            }
            return world.m_45517_(LightLayer.BLOCK, pos) <= maxlight;
        });
    }

    private void addMinAdditionalDifficultyCheck(Float mindifficulty) {
        this.checks.add((event, query) -> query.getWorld(event).m_6436_(query.getPos(event)).m_19056_() >= mindifficulty.floatValue());
    }

    private void addMaxAdditionalDifficultyCheck(Float maxdifficulty) {
        this.checks.add((event, query) -> query.getWorld(event).m_6436_(query.getPos(event)).m_19056_() <= maxdifficulty.floatValue());
    }

    private void addHeightCheck(String input) {
        Predicate<Integer> expression = Tools.parseExpression(input);
        if (expression != null) {
            this.checks.add((event, query) -> expression.test(query.getY(event)));
        }
    }

    private void addMaxHeightCheck(int maxheight) {
        this.checks.add((event, query) -> query.getY(event) <= maxheight);
    }

    private void addMinHeightCheck(int minheight) {
        this.checks.add((event, query) -> query.getY(event) >= minheight);
    }

    public boolean match(Object event, IEventQuery query) {
        for (BiFunction<Object, IEventQuery, Boolean> rule : this.checks) {
            if (rule.apply(event, query).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static Predicate<Integer> getExpressionInteger(String expression, boolean onlyInt) {
        try {
            if (expression.startsWith(">=")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i >= amount;
            }
            if (expression.startsWith(">")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i > amount;
            }
            if (expression.startsWith("<=")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i <= amount;
            }
            if (expression.startsWith("<")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i < amount;
            }
            if (expression.startsWith("=")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i == amount;
            }
            if (expression.startsWith("!=") || expression.startsWith("<>")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i != amount;
            }
            if (expression.contains("-")) {
                String[] split = StringUtils.split((String)expression, (String)"-");
                int amount1 = Integer.parseInt(split[0]);
                int amount2 = Integer.parseInt(split[1]);
                return i -> i >= amount1 && i <= amount2;
            }
            int amount = Integer.parseInt(expression);
            return i -> i == amount;
        }
        catch (NumberFormatException e) {
            if (onlyInt) {
                ErrorHandler.error("Bad expression '" + expression + "'!");
            }
            return null;
        }
    }

    private static Predicate<Integer> getExpression(JsonElement element) {
        if (element.isJsonPrimitive()) {
            if (element.getAsJsonPrimitive().isNumber()) {
                int amount = element.getAsInt();
                return i -> i == amount;
            }
            return CommonRuleEvaluator.getExpressionInteger(element.getAsString(), true);
        }
        ErrorHandler.error("Bad expression!");
        return null;
    }

    private static Predicate<CompoundTag> getExpressionOrString(JsonElement element, String tag) {
        if (element.isJsonPrimitive()) {
            if (element.getAsJsonPrimitive().isNumber()) {
                int amount = element.getAsInt();
                return tagCompound -> tagCompound.m_128451_(tag) == amount;
            }
            if (element.getAsJsonPrimitive().isBoolean()) {
                boolean v = element.getAsBoolean();
                return tagCompound -> tagCompound.m_128471_(tag) == v;
            }
            String str = element.getAsString();
            Predicate<Integer> predicate = CommonRuleEvaluator.getExpressionInteger(str, false);
            if (predicate == null) {
                return tagCompound -> str.equals(tagCompound.m_128461_(tag));
            }
            return tagCompound -> predicate.test(tagCompound.m_128451_(tag));
        }
        ErrorHandler.error("Bad expression!");
        return null;
    }

    private static Predicate<ItemStack> getMatcher(String name, Logger logger) {
        ItemStack stack = Tools.parseStack(name, logger);
        if (!stack.m_41619_()) {
            if (name.contains("/") && name.contains("@")) {
                return s -> ItemStack.m_41746_((ItemStack)s, (ItemStack)stack) && ItemStack.m_41658_((ItemStack)s, (ItemStack)stack);
            }
            if (name.contains("/")) {
                return s -> ItemStack.m_41758_((ItemStack)s, (ItemStack)stack) && ItemStack.m_41658_((ItemStack)s, (ItemStack)stack);
            }
            if (name.contains("@")) {
                return s -> ItemStack.m_41746_((ItemStack)s, (ItemStack)stack);
            }
            return s -> s.m_41720_() == stack.m_41720_();
        }
        return null;
    }

    private static Predicate<ItemStack> getMatcher(JsonObject obj, Logger logger) {
        Predicate<Integer> energy;
        List<Predicate<CompoundTag>> nbtMatchers;
        Predicate<ItemStack> finalTest;
        Predicate<Integer> count;
        Predicate<ItemStack> test;
        if (obj.has("empty")) {
            boolean empty = obj.get("empty").getAsBoolean();
            return s -> s.m_41619_() == empty;
        }
        String name = obj.get("item").getAsString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            ErrorHandler.error("Unknown item '" + name + "'!");
            return null;
        }
        if (obj.has("damage")) {
            Predicate<Integer> damage = CommonRuleEvaluator.getExpression(obj.get("damage"));
            if (damage == null) {
                return null;
            }
            test = s -> s.m_41720_() == item && damage.test(s.m_41773_());
        } else {
            test = s -> s.m_41720_() == item;
        }
        if (obj.has("count") && (count = CommonRuleEvaluator.getExpression(obj.get("count"))) != null) {
            finalTest = test;
            test = s -> finalTest.test((ItemStack)s) && count.test(s.m_41613_());
        }
        if (obj.has("tag")) {
            ResourceLocation tagname = new ResourceLocation(obj.get("tag").getAsString());
            TagKey key = TagKey.m_203882_((ResourceKey)Registry.f_122827_.m_123023_(), (ResourceLocation)tagname);
            Predicate<ItemStack> finalTest2 = test;
            test = s -> finalTest2.test((ItemStack)s) && s.m_204117_(key);
        }
        if (obj.has("mod")) {
            String mod = obj.get("mod").getAsString();
            finalTest = test;
            test = s -> finalTest.test((ItemStack)s) && "mod".equals(s.m_41720_().getRegistryName().m_135827_());
        }
        if (obj.has("nbt") && (nbtMatchers = CommonRuleEvaluator.getNbtMatchers(obj, logger)) != null) {
            finalTest = test;
            test = s -> finalTest.test((ItemStack)s) && nbtMatchers.stream().allMatch(p -> p.test(s.m_41783_()));
        }
        if (obj.has("energy") && (energy = CommonRuleEvaluator.getExpression(obj.get("energy"))) != null) {
            finalTest = test;
            test = s -> finalTest.test((ItemStack)s) && energy.test(CommonRuleEvaluator.getEnergy(s));
        }
        return test;
    }

    private static int getEnergy(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    private boolean contains(LevelAccessor world, BlockPos pos, @Nullable Direction side, @Nonnull List<Predicate<ItemStack>> matchers) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity != null) {
            return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(h -> {
                for (int i = 0; i < h.getSlots(); ++i) {
                    ItemStack stack = h.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    for (Predicate matcher : matchers) {
                        if (!matcher.test(stack)) continue;
                        return true;
                    }
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private int getEnergy(LevelAccessor world, BlockPos pos, @Nullable Direction side) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity != null) {
            return tileEntity.getCapability(CapabilityEnergy.ENERGY, side).map(IEnergyStorage::getEnergyStored).orElse(0);
        }
        return 0;
    }

    private static List<Predicate<CompoundTag>> getNbtMatchers(JsonObject obj, Logger logger) {
        JsonArray nbtArray = obj.getAsJsonArray("nbt");
        return CommonRuleEvaluator.getNbtMatchers(nbtArray, logger);
    }

    private static List<Predicate<CompoundTag>> getNbtMatchers(JsonArray nbtArray, Logger logger) {
        ArrayList<Predicate<CompoundTag>> nbtMatchers = new ArrayList<Predicate<CompoundTag>>();
        for (JsonElement element : nbtArray) {
            JsonObject o = element.getAsJsonObject();
            String tag = o.get("tag").getAsString();
            if (o.has("contains")) {
                List<Predicate<CompoundTag>> subMatchers = CommonRuleEvaluator.getNbtMatchers(o.getAsJsonArray("contains"), logger);
                nbtMatchers.add(tagCompound -> {
                    if (tagCompound != null) {
                        ListTag list = tagCompound.m_128437_(tag, 10);
                        for (Tag base : list) {
                            for (Predicate matcher : subMatchers) {
                                if (!matcher.test((CompoundTag)base)) continue;
                                return true;
                            }
                        }
                    }
                    return false;
                });
                continue;
            }
            Predicate<CompoundTag> nbt = CommonRuleEvaluator.getExpressionOrString(o.get("value"), tag);
            if (nbt == null) continue;
            nbtMatchers.add(nbt);
        }
        return nbtMatchers;
    }

    public static List<Predicate<ItemStack>> getItems(List<String> itemNames, Logger logger) {
        ArrayList<Predicate<ItemStack>> items = new ArrayList<Predicate<ItemStack>>();
        Iterator<String> iterator = itemNames.iterator();
        while (iterator.hasNext()) {
            Predicate<ItemStack> matcher;
            JsonParser parser = new JsonParser();
            String json = iterator.next();
            JsonElement element = parser.parse(json);
            if (element.isJsonPrimitive()) {
                String name = element.getAsString();
                matcher = CommonRuleEvaluator.getMatcher(name, logger);
                if (matcher == null) continue;
                items.add(matcher);
                continue;
            }
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                matcher = CommonRuleEvaluator.getMatcher(obj, logger);
                if (matcher == null) continue;
                items.add(matcher);
                continue;
            }
            ErrorHandler.error("Item description '" + json + "' is not valid!");
        }
        return items;
    }

    public void addHelmetCheck(List<String> itemList) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(itemList, this.logger);
        this.addArmorCheck(items, EquipmentSlot.HEAD);
    }

    public void addChestplateCheck(List<String> itemList) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(itemList, this.logger);
        this.addArmorCheck(items, EquipmentSlot.CHEST);
    }

    public void addLeggingsCheck(List<String> itemList) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(itemList, this.logger);
        this.addArmorCheck(items, EquipmentSlot.LEGS);
    }

    public void addBootsCheck(List<String> itemList) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(itemList, this.logger);
        this.addArmorCheck(items, EquipmentSlot.FEET);
    }

    private void addArmorCheck(List<Predicate<ItemStack>> items, EquipmentSlot slot) {
        this.checks.add((event, query) -> {
            ItemStack armorItem;
            Player player = query.getPlayer(event);
            if (player != null && !(armorItem = player.m_6844_(slot)).m_41619_()) {
                for (Predicate item : items) {
                    if (!item.test(armorItem)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public void addHeldItemCheck(List<String> itemList) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(itemList, this.logger);
        this.checks.add((event, query) -> {
            ItemStack mainhand;
            Player player = query.getPlayer(event);
            if (player != null && !(mainhand = player.m_21205_()).m_41619_()) {
                for (Predicate item : items) {
                    if (!item.test(mainhand)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public void addOffHandItemCheck(List<String> itemList) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(itemList, this.logger);
        this.checks.add((event, query) -> {
            ItemStack offhand;
            Player player = query.getPlayer(event);
            if (player != null && !(offhand = player.m_21206_()).m_41619_()) {
                for (Predicate item : items) {
                    if (!item.test(offhand)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public void addBothHandsItemCheck(List<String> itemList) {
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(itemList, this.logger);
        this.checks.add((event, query) -> {
            Player player = query.getPlayer(event);
            if (player != null) {
                ItemStack mainhand;
                ItemStack offhand = player.m_21206_();
                if (!offhand.m_41619_()) {
                    for (Predicate item : items) {
                        if (!item.test(offhand)) continue;
                        return true;
                    }
                }
                if (!(mainhand = player.m_21205_()).m_41619_()) {
                    for (Predicate item : items) {
                        if (!item.test(mainhand)) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }

    private void addStateCheck(String s) {
        String value;
        String state;
        if (!this.compatibility.hasEnigmaScript()) {
            this.logger.warn("EnigmaScript is missing: this test cannot work!");
            return;
        }
        String[] split = StringUtils.split((String)s, (char)'=');
        try {
            state = split[0];
            value = split[1];
        }
        catch (Exception e) {
            ErrorHandler.error("Bad state=value specifier '" + s + "'!");
            return;
        }
        this.checks.add((event, query) -> value.equals(this.compatibility.getState(query.getWorld(event), state)));
    }

    private void addPStateCheck(String s) {
        String value;
        String state;
        if (!this.compatibility.hasEnigmaScript()) {
            this.logger.warn("EnigmaScript is missing: this test cannot work!");
            return;
        }
        String[] split = StringUtils.split((String)s, (char)'=');
        try {
            state = split[0];
            value = split[1];
        }
        catch (Exception e) {
            ErrorHandler.error("Bad state=value specifier '" + s + "'!");
            return;
        }
        this.checks.add((event, query) -> value.equals(this.compatibility.getPlayerState(query.getPlayer(event), state)));
    }

    private void addSummerCheck(Boolean s) {
        if (!this.compatibility.hasSereneSeasons()) {
            this.logger.warn("Serene Seasons is missing: this test cannot work!");
            return;
        }
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isSummer((Level)Tools.getServerWorld(query.getWorld(event))));
    }

    private void addWinterCheck(Boolean s) {
        if (!this.compatibility.hasSereneSeasons()) {
            this.logger.warn("Serene Seasons is missing: this test cannot work!");
            return;
        }
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isWinter((Level)Tools.getServerWorld(query.getWorld(event))));
    }

    private void addSpringCheck(Boolean s) {
        if (!this.compatibility.hasSereneSeasons()) {
            this.logger.warn("Serene Seasons is missing: this test cannot work!");
            return;
        }
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isSpring((Level)Tools.getServerWorld(query.getWorld(event))));
    }

    private void addAutumnCheck(Boolean s) {
        if (!this.compatibility.hasSereneSeasons()) {
            this.logger.warn("Serene Seasons is missing: this test cannot work!");
            return;
        }
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isAutumn((Level)Tools.getServerWorld(query.getWorld(event))));
    }

    private void addGameStageCheck(String stage) {
        if (!this.compatibility.hasGameStages()) {
            this.logger.warn("Game Stages is missing: the 'gamestage' test cannot work!");
            return;
        }
        this.checks.add((event, query) -> this.compatibility.hasGameStage(query.getPlayer(event), stage));
    }

    private void addInCityCheck(boolean incity) {
        if (!this.compatibility.hasLostCities()) {
            this.logger.warn("The Lost Cities is missing: the 'incity' test cannot work!");
            return;
        }
        if (incity) {
            this.checks.add((event, query) -> this.compatibility.isCity(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isCity(query, event));
        }
    }

    private void addInStreetCheck(boolean instreet) {
        if (!this.compatibility.hasLostCities()) {
            this.logger.warn("The Lost Cities is missing: the 'instreet' test cannot work!");
            return;
        }
        if (instreet) {
            this.checks.add((event, query) -> this.compatibility.isStreet(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isStreet(query, event));
        }
    }

    private void addInSphereCheck(boolean insphere) {
        if (!this.compatibility.hasLostCities()) {
            this.logger.warn("The Lost Cities is missing: the 'insphere' test cannot work!");
            return;
        }
        if (insphere) {
            this.checks.add((event, query) -> this.compatibility.inSphere(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.inSphere(query, event));
        }
    }

    private void addInBuildingCheck(boolean inbuilding) {
        if (!this.compatibility.hasLostCities()) {
            this.logger.warn("The Lost Cities is missing: the 'inbuilding' test cannot work!");
            return;
        }
        if (inbuilding) {
            this.checks.add((event, query) -> this.compatibility.isBuilding(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isBuilding(query, event));
        }
    }

    private void addBuildingCheck(List<String> buildings) {
        if (!this.compatibility.hasLostCities()) {
            this.logger.warn("The Lost Cities is missing: the 'building' test cannot work!");
            return;
        }
        HashSet<String> buildingSet = new HashSet<String>(buildings);
        this.checks.add((event, query) -> {
            String building = this.compatibility.getBuilding(query, event);
            return building != null && buildingSet.contains(building);
        });
    }

    public void addBaubleCheck(List<String> itemList, Supplier<int[]> slotSupplier) {
        if (!this.compatibility.hasBaubles()) {
            this.logger.warn("Baubles is missing: this test cannot work!");
            return;
        }
        List<Predicate<ItemStack>> items = CommonRuleEvaluator.getItems(itemList, this.logger);
        this.checks.add((event, query) -> {
            Player player = query.getPlayer(event);
            if (player != null) {
                for (int slot : (int[])slotSupplier.get()) {
                    ItemStack stack = this.compatibility.getBaubleStack(player, slot);
                    if (stack.m_41619_()) continue;
                    for (Predicate item : items) {
                        if (!item.test(stack)) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }
}

